/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.catalogos.ComprobantesReembolso;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ComprobanteCompra;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ComprobanteModificado;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ComprobanteRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.compras.DetalleAirCompras;
import ec.gob.sri.dimm.ats.modelo.obj.compras.FormaPago;
import ec.gob.sri.dimm.ats.modelo.obj.compras.Proveedor;
import ec.gob.sri.dimm.ats.modelo.obj.compras.Reembolso;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransaccionCompra
extends ObjetoModeloSucesorValidable<Iva>
implements Exportable,
Importable {
    private static final long serialVersionUID = -150139565000231665L;
    public static final String CC_DETALLE_AIR_COMPRAS = "detallesAirCompras";
    public static final String CC_REEMBOLSOS = "reembolsos";
    private Proveedor proveedor;
    private ComprobanteCompra comprobanteCompra;
    private PagoLocalExterior pagoLocalExterior;
    private List<DetalleAirCompras> detallesAirCompras;
    private List<Reembolso> reembolsos;
    private BigDecimal totalBasesReembolsos = BigDecimal.ZERO;
    private String totalReembolsos;
    private ComprobanteRetencion comprobanteRetencion;
    private ComprobanteModificado comprobanteModificado;

    public TransaccionCompra() {
        this.proveedor = new Proveedor();
        this.proveedor.setPropietario((ObjetoModelo)this);
        this.comprobanteCompra = new ComprobanteCompra();
        this.comprobanteCompra.setPropietario((ObjetoModelo)this);
        this.pagoLocalExterior = new PagoLocalExterior();
        this.pagoLocalExterior.setPropietario((ObjetoModelo)this);
        this.detallesAirCompras = new ArrayList<DetalleAirCompras>();
        this.reembolsos = new ArrayList<Reembolso>();
        this.totalReembolsos = "0.00";
        this.comprobanteRetencion = new ComprobanteRetencion();
        this.comprobanteRetencion.setPropietario((ObjetoModelo)this);
        this.comprobanteModificado = new ComprobanteModificado();
        this.comprobanteModificado.setPropietario((ObjetoModelo)this);
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (InfoPantallas.COMPRA_COMPROBANTE.equals(this.getContextoValidacion().obtener(InfoPantallas.COMPRA_COMPROBANTE.toString()))) {
            resultado = this.getComprobanteCompra().validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            if (("04".equals(this.getComprobanteCompra().getTipoComprobante()) || "05".equals(this.getComprobanteCompra().getTipoComprobante())) && !(resultado = this.getComprobanteModificado().validar()).esEstadoExitoso()) {
                return resultado;
            }
        }
        if (InfoPantallas.COMPRA_PAGO_LOCAL.equals(this.getContextoValidacion().obtener(InfoPantallas.COMPRA_PAGO_LOCAL.toString()))) {
            resultado = this.getPagoLocalExterior().validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            resultado = this.getComprobanteRetencion().validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
        }
        return resultado.pasarValidacion();
    }

    public void agregarDetalleAirCompras(DetalleAirCompras detalleAirCompras) {
        detalleAirCompras.setPropietario((ObjetoModelo)this);
        this.detallesAirCompras.add(detalleAirCompras);
        this.firePropertyChange(CC_DETALLE_AIR_COMPRAS, null, this.detallesAirCompras);
    }

    public boolean elimanarDetalleAirCompras(DetalleAirCompras detalleAirCompras) {
        boolean eliminado = this.detallesAirCompras.remove((Object)detalleAirCompras);
        if (eliminado) {
            this.firePropertyChange(CC_DETALLE_AIR_COMPRAS, null, this.detallesAirCompras);
        }
        return eliminado;
    }

    public void agregarReembolsos(Reembolso reembolso) {
        reembolso.setPropietario((ObjetoModelo)reembolso);
        this.reembolsos.add(reembolso);
        this.firePropertyChange(CC_REEMBOLSOS, null, this.reembolsos);
    }

    public boolean eliminarReembolso(Reembolso reembolso) {
        if (this.validarSePuedeEliminarElReembolsoSinExcederSumaDeBasesDeComprobante(reembolso)) {
            boolean eliminado = this.reembolsos.remove((Object)reembolso);
            if (eliminado) {
                this.actualizarTotalDeReembolso(reembolso);
                this.firePropertyChange(CC_REEMBOLSOS, null, this.reembolsos);
            }
            return eliminado;
        }
        return false;
    }

    private boolean validarSePuedeEliminarElReembolsoSinExcederSumaDeBasesDeComprobante(Reembolso reembolso) {
        if (((Iva)this.propietario).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            BigDecimal sumaBasesImponiblesReembolso = this.calcularSumaBasesImponiblesReembolsoPorTipoDeComprobante(reembolso);
            return this.comprobanteCompra.getValoresComprovanteVenta().getSumaBasesImponibles().compareTo(this.totalBasesReembolsos.subtract(sumaBasesImponiblesReembolso)) >= 0;
        }
        return true;
    }

    private void actualizarTotalDeReembolso(Reembolso reembolso) {
        BigDecimal sumaBasesImponiblesReembolso = this.calcularSumaBasesImponiblesReembolsoPorTipoDeComprobante(reembolso);
        this.setTotalBasesReembolsos(this.totalBasesReembolsos.subtract(sumaBasesImponiblesReembolso));
    }

    private BigDecimal calcularSumaBasesImponiblesReembolsoPorTipoDeComprobante(Reembolso reembolso) {
        BigDecimal sumaBasesImponiblesReembolso = reembolso.getValoresComprobanteReembolso().getSumaBasesImponibles();
        if (ComprobantesReembolso.codigosComprobantesReembolsoResta.containsKey(reembolso.getTipoComprobanteReembolso())) {
            sumaBasesImponiblesReembolso = sumaBasesImponiblesReembolso.negate();
        }
        return sumaBasesImponiblesReembolso;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        this.importarProveedor(elemento);
        this.importarComprobante(elemento);
        this.importarTotalReembolsos(elemento);
        if (Util.existeElementoImportar(elemento, "pagoExterior")) {
            this.getPagoLocalExterior().importar(elemento, null);
        }
        if (Util.existeElementoImportar(elemento, "estabRetencion1")) {
            this.getComprobanteRetencion().importar(elemento, null);
        }
        if (Util.existeElementoImportar(elemento, "docModificado") && ("04".equals(this.getComprobanteCompra().getTipoComprobante()) || "05".equals(this.getComprobanteCompra().getTipoComprobante()))) {
            this.getComprobanteModificado().importar(elemento, null);
        }
        this.importarRetencionesAIR(elemento);
        this.importarReembolsos(elemento);
        return this;
    }

    private void importarTotalReembolsos(Element elemento) {
        if (Util.existeElementoImportar(elemento, "totbasesImpReemb")) {
            NodeList valorList = elemento.getElementsByTagName("totbasesImpReemb");
            Element eValor = (Element)valorList.item(0);
            this.setTotalBasesReembolsos(new BigDecimal(eValor.getTextContent().trim()));
        }
    }

    private void importarReembolsos(Element elemento) {
        NodeList nl = elemento.getElementsByTagName("reembolso");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Reembolso reembolso = new Reembolso();
                reembolso.importar(elem, null);
                this.agregarReembolsos(reembolso);
            }
            ++i;
        }
    }

    private void importarRetencionesAIR(Element elemento) {
        NodeList nl = elemento.getElementsByTagName("detalleAir");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                DetalleAirCompras detalleAirCompras = new DetalleAirCompras();
                detalleAirCompras.setPropietario((ObjetoModelo)this);
                detalleAirCompras.inicializar();
                detalleAirCompras.importar(elem, null);
                this.agregarDetalleAirCompras(detalleAirCompras);
            }
            ++i;
        }
    }

    private void importarComprobante(Element elemento) {
        this.getComprobanteCompra().importar(elemento, null);
    }

    private void importarProveedor(Element elemento) {
        this.getProveedor().importar(elemento, null);
    }

    public Proveedor getProveedor() {
        return this.proveedor;
    }

    public ComprobanteCompra getComprobanteCompra() {
        return this.comprobanteCompra;
    }

    public PagoLocalExterior getPagoLocalExterior() {
        return this.pagoLocalExterior;
    }

    public List<DetalleAirCompras> getDetallesAirCompras() {
        return this.detallesAirCompras;
    }

    public List<Reembolso> getReembolsos() {
        return this.reembolsos;
    }

    public ComprobanteRetencion getComprobanteRetencion() {
        return this.comprobanteRetencion;
    }

    public ComprobanteModificado getComprobanteModificado() {
        return this.comprobanteModificado;
    }

    public String getTotalReembolsos() {
        return this.totalReembolsos;
    }

    public void setTotalReembolsos(String totalReembolsos) {
        this.totalReembolsos = totalReembolsos;
    }

    public BigDecimal getTotalBasesReembolsos() {
        return this.totalBasesReembolsos;
    }

    public void setTotalBasesReembolsos(BigDecimal totalBasesReembolsos) {
        this.totalBasesReembolsos = totalBasesReembolsos;
        this.formatearTotalReembolsosAMostrar(totalBasesReembolsos);
    }

    private void formatearTotalReembolsosAMostrar(BigDecimal totalBasesReembolsos) {
        BigDecimal valorFormateado = BigDecimal.ZERO;
        if (totalBasesReembolsos.compareTo(BigDecimal.ZERO) >= 0) {
            valorFormateado = totalBasesReembolsos;
        }
        valorFormateado.setScale(2, 2);
        this.setTotalReembolsos(valorFormateado.toString());
    }

    public Element exportar(Document documento, Element elemento) {
        Element detalleCompra = documento.createElement("detalleCompras");
        Element tagCompra = documento.createElement("codSustento");
        tagCompra.setTextContent(this.getComprobanteCompra().getTipoSustento());
        detalleCompra.appendChild(tagCompra);
        String codTpoIdentf = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("1", this.getProveedor().getTipoIdentificacion());
        this.exportarProveedor(documento, detalleCompra, codTpoIdentf);
        this.exportarComprobante(documento, detalleCompra);
        this.exportarBasesImponibles(documento, detalleCompra);
        this.exportarMontosComprobante(documento, detalleCompra);
        this.exportarValoresDeRetenciones(documento, detalleCompra);
        this.exportarTotalReembolsos(documento, detalleCompra);
        if (this.getPagoLocalExterior() != null && ((Iva)this.getPropietario()).periodo.isPeriodoDesdeEnero2013()) {
            tagCompra = this.getPagoLocalExterior().exportar(documento, null);
            detalleCompra.appendChild(tagCompra);
        }
        tagCompra = documento.createElement("formasDePago");
        for (FormaPago fp : this.getComprobanteCompra().getValoresComprovanteVenta().getFormasPago()) {
            tagCompra.appendChild(fp.exportar(documento, null));
        }
        detalleCompra.appendChild(tagCompra);
        tagCompra = this.obtenerAirXml(documento);
        detalleCompra.appendChild(tagCompra);
        if (this.getComprobanteRetencion().isObligatorio()) {
            tagCompra = documento.createElement("estabRetencion1");
            tagCompra.setTextContent(this.getComprobanteRetencion().getEstablecimiento());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("ptoEmiRetencion1");
            tagCompra.setTextContent(this.getComprobanteRetencion().getPuntoEmision());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("secRetencion1");
            tagCompra.setTextContent(this.getComprobanteRetencion().getSecuencial());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("autRetencion1");
            tagCompra.setTextContent(this.getComprobanteRetencion().getNumAutorizacion());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("fechaEmiRet1");
            tagCompra.setTextContent(Util.dateToStringWithFormat(this.getComprobanteRetencion().getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
            detalleCompra.appendChild(tagCompra);
        }
        if (!"000".equals(this.getComprobanteModificado().getEstablecimiento())) {
            tagCompra = documento.createElement("docModificado");
            tagCompra.setTextContent(this.getComprobanteModificado().getTipoComprobante());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("estabModificado");
            tagCompra.setTextContent(this.getComprobanteModificado().getEstablecimiento());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("ptoEmiModificado");
            tagCompra.setTextContent(this.getComprobanteModificado().getPuntoEmision());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("secModificado");
            tagCompra.setTextContent(this.getComprobanteModificado().getSecuencial());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("autModificado");
            tagCompra.setTextContent(this.getComprobanteModificado().getNumAutorizacion());
            detalleCompra.appendChild(tagCompra);
        }
        tagCompra = this.exportarReembolsos(documento);
        detalleCompra.appendChild(tagCompra);
        return detalleCompra;
    }

    private void exportarProveedor(Document documento, Element detalleCompra, String codTpoIdentf) {
        Element tagCompra = documento.createElement("tpIdProv");
        tagCompra.setTextContent(codTpoIdentf);
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("idProv");
        tagCompra.setTextContent(this.getProveedor().getIdentificacion());
        detalleCompra.appendChild(tagCompra);
    }

    private void exportarTotalReembolsos(Document documento, Element detalleCompra) {
        if (((Iva)this.propietario).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            Element tagReembolso = documento.createElement("totbasesImpReemb");
            tagReembolso.setTextContent(this.getTotalReembolsos());
            detalleCompra.appendChild(tagReembolso);
        }
    }

    private void exportarComprobante(Document documento, Element detalleCompra) {
        Element tagCompra = documento.createElement("tipoComprobante");
        tagCompra.setTextContent(this.getComprobanteCompra().getTipoComprobante());
        detalleCompra.appendChild(tagCompra);
        this.exportarTipoDeProveedorYParteRelacionada(documento, detalleCompra);
        tagCompra = documento.createElement("fechaRegistro");
        tagCompra.setTextContent(Util.dateToStringWithFormat(this.getComprobanteCompra().getFechaRegistro(), Constantes.FORMATO_FECHA.toPattern()));
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("establecimiento");
        tagCompra.setTextContent(this.getComprobanteCompra().getEstablecimiento());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("puntoEmision");
        tagCompra.setTextContent(this.getComprobanteCompra().getPuntoEmision());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("secuencial");
        tagCompra.setTextContent(this.getComprobanteCompra().getSecuencial());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("fechaEmision");
        tagCompra.setTextContent(Util.dateToStringWithFormat(this.getComprobanteCompra().getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("autorizacion");
        tagCompra.setTextContent(this.getComprobanteCompra().getNumAutorizacion());
        detalleCompra.appendChild(tagCompra);
    }

    private void exportarTipoDeProveedorYParteRelacionada(Document documento, Element detalleCompra) {
        if ("P".equals(this.getProveedor().getTipoIdentificacion()) && ((Iva)this.getPropietario()).periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015() || ((Iva)this.getPropietario()).periodo.isPeriodoDeAnexoDesdeMarzo2015() || ((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            Element tagCompra = documento.createElement("tipoProv");
            tagCompra.setTextContent(this.getProveedor().getTipoProveedor());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("denoProv");
            tagCompra.setTextContent(this.getProveedor().getRazonSocial());
            detalleCompra.appendChild(tagCompra);
            tagCompra = documento.createElement("parteRel");
            tagCompra.setTextContent(this.getProveedor().getParteRelacionada());
            detalleCompra.appendChild(tagCompra);
        }
    }

    private void exportarValoresDeRetenciones(Document documento, Element detalleCompra) {
        Element tagCompra = documento.createElement("valRetBien10");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionIva10());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("valRetServ20");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionIva20());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("valorRetBienes");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionIvaBienes());
        detalleCompra.appendChild(tagCompra);
        if (((Iva)this.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeEnero2016()) {
            tagCompra = documento.createElement("valRetServ50");
            tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionIvaServicios50());
            detalleCompra.appendChild(tagCompra);
        }
        tagCompra = documento.createElement("valorRetServicios");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionIvaServicios());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("valRetServ100");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionIvaCien());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("valorRetencionNc");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getRetencionNCIva());
        detalleCompra.appendChild(tagCompra);
    }

    private void exportarMontosComprobante(Document documento, Element detalleCompra) {
        Element tagCompra = documento.createElement("montoIce");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getMontoIce());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("montoIva");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getMontoIva());
        detalleCompra.appendChild(tagCompra);
    }

    private void exportarBasesImponibles(Document documento, Element detalleCompra) {
        Element tagCompra = documento.createElement("baseNoGraIva");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getBaseNoIva());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("baseImponible");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getBaseIvaCero());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("baseImpGrav");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getBaseIvaNoCero());
        detalleCompra.appendChild(tagCompra);
        tagCompra = documento.createElement("baseImpExe");
        tagCompra.setTextContent(this.getComprobanteCompra().getValoresComprovanteVenta().getBaseExcentaIva());
        detalleCompra.appendChild(tagCompra);
    }

    private Element exportarReembolsos(Document documento) {
        Element elmReemb = documento.createElement(CC_REEMBOLSOS);
        for (Reembolso reembolso : this.getReembolsos()) {
            Element emRe = reembolso.exportar(documento, null);
            elmReemb.appendChild(emRe);
        }
        return elmReemb;
    }

    private Element obtenerAirXml(Document documento) {
        Element air = documento.createElement("air");
        for (DetalleAirCompras dac : this.getDetallesAirCompras()) {
            Element detAir = dac.exportar(documento, null);
            air.appendChild(detAir);
        }
        return air;
    }

    public void setProveedor(Proveedor proveedor) {
        this.proveedor = proveedor;
    }

    public void setComprobanteCompra(ComprobanteCompra comprobanteCompra) {
        this.comprobanteCompra = comprobanteCompra;
    }

    public void setPagoLocalExterior(PagoLocalExterior pagoLocalExterior) {
        this.pagoLocalExterior = pagoLocalExterior;
    }

    public void setDetallesAirCompras(List<DetalleAirCompras> detallesAirCompras) {
        this.detallesAirCompras = detallesAirCompras;
    }

    public void setReembolsos(List<Reembolso> reembolsos) {
        this.reembolsos = reembolsos;
    }

    public void setComprobanteRetencion(ComprobanteRetencion comprobanteRetencion) {
        this.comprobanteRetencion = comprobanteRetencion;
    }

    public void setComprobanteModificado(ComprobanteModificado comprobanteModificado) {
        this.comprobanteModificado = comprobanteModificado;
    }
}

